IF NOT OBJECT_ID('UFD_EST_ALCADA_CP_PED_STS') IS NULL
	BEGIN 
		DROP FUNCTION UFD_EST_ALCADA_CP_PED_STS
	END

GO
	
CREATE FUNCTION UFD_EST_ALCADA_CP_PED_STS(@CD_EMP INT , @CD_CTR INT, @CD_PED_SOL INT)
RETURNS @RS_RETURN TABLE (	CD_EMP			INT, 
							CD_PED_SOL		INT, 
							CD_CTR			INT,
							CD_GRP_PED		INT,	  
							CD_COMPRADOR	INT, 
							NM_COMPRADOR	NVARCHAR(100), 
							DS_USUAL_ALCADA NVARCHAR(100), 
							ST_PEND_LIB		INT,
							ST_LIB			INT,
							ST_CANCEL		INT)
AS 
	BEGIN	
		INSERT INTO @RS_RETURN
			SELECT 
				EST_ALCADA_CP_PED.CD_EMP, 
				EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_PED_SOL, 
				EST_ALCADA_CP_PED.CD_CTR,
				EST_ALCADA_CP_PED.CD_GRP_PED,	  
				EST_ALCADA_CP_PED.CD_COMPRADOR, 
				EST_COMPRADOR.NM_COMPRADOR, 
				EST_ALCADA_CP_PED.DS_USUAL_ALCADA,
				(CASE WHEN (ISNULL(EST_ALCADA_CP_PED_LIB.CD_CTR, 0) + ISNULL(EST_ALCADA_CP_PED_CANCEL.CD_CTR, 0)) = 0 THEN 1 ELSE 0 END) AS ST_PEND_LIB,
				(CASE WHEN ISNULL(EST_ALCADA_CP_PED_LIB.CD_CTR, 0) = 0 THEN 0 ELSE 1 END) AS ST_LIB,
				(CASE WHEN ISNULL(EST_ALCADA_CP_PED_CANCEL.CD_CTR, 0) = 0 THEN 0 ELSE 1 END) AS ST_CANCEL
			FROM EST_ALCADA_CP_PED
				INNER JOIN EST_COMPRADOR ON 
					EST_ALCADA_CP_PED.CD_COMPRADOR = EST_COMPRADOR.CD_COMPRADOR 
				INNER JOIN EST_PED_ELTR_GRP_PED_EST_PED_ELTR ON 
					EST_ALCADA_CP_PED.CD_EMP = EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_EMP 
					AND EST_ALCADA_CP_PED.CD_GRP_PED = EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_GRP_PED 
				LEFT JOIN EST_ALCADA_CP_PED_LIB ON 
					EST_ALCADA_CP_PED.CD_CTR = EST_ALCADA_CP_PED_LIB.CD_CTR
				LEFT JOIN EST_ALCADA_CP_PED_CANCEL  ON 
					EST_ALCADA_CP_PED.CD_CTR = EST_ALCADA_CP_PED_CANCEL.CD_CTR
			WHERE 
				EST_ALCADA_CP_PED.CD_EMP = @CD_EMP
				AND EST_ALCADA_CP_PED.CD_CTR = (CASE WHEN @CD_CTR > 0 THEN @CD_CTR ELSE EST_ALCADA_CP_PED.CD_CTR END)				
				AND EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_PED_SOL = (CASE WHEN @CD_PED_SOL > 0 THEN @CD_PED_SOL ELSE EST_PED_ELTR_GRP_PED_EST_PED_ELTR.CD_PED_SOL END)

		RETURN

	END
						